//Author: Ashley Robinson
module Sequencer
# (parameter n = 4)
(
  input logic start,Q0,clock,
  output logic add,shift,nreset,ready 
);

parameter //All used states in the cycle (Gray code)
  idle = 2'b00,
  adding = 2'b01,
  shifting = 2'b11,
  stopped = 2'b10;
  
logic [1:0]//Internal logic holding the next state 
  current,
  next;
  
logic [n - 1:0]//now and next states for the counter
  count_now,
  count_next;

//Flip flops that cycle through the states in the sequencer
always_ff@(posedge clock)
    current <= next;
  
//Flip flops that hold the state of count  
always_ff@(posedge clock) 
  count_now <= count_next;
     
//Combinational logic that determines next state
always_comb
  case(current)
    idle:
      begin
        count_next = n;
        add = 0;
        shift = 0;
        nreset = 0;
        ready = 0;//intialise values
        if(start) 
          next = adding;
        else
          next = idle;
      end
    adding:
      begin
        nreset = 1;
        shift = 0;
        ready = 0;
        count_next = count_now - 1;
        next = shifting;
        add = Q0;
      end
    shifting:
      begin
        add = 0;
        shift = 1;
        nreset = 1;
        ready = 0;
        count_next = count_now;
        if(count_now == 0)
          next = stopped;
        else
          next = adding;
      end
    stopped:
      begin
        ready = 1;
        shift = 0;
        nreset = 1;
        add = 0;
        count_next = count_now;
        if(start)
          next = idle;
        else
          next = stopped;
      end  
    default:
      begin
        ready = 0;
        shift = 0;
        nreset = 0;
        add = 0;
        count_next = count_now;
        next = idle;
      end
  endcase
endmodule // End of module Main 