//Author: Ashley Robinson
module Regs
#(parameter n = 4)
(
  input logic nreset, add, shift, C, clock, 
  input logic[n-1:0] Q, Sum, 
  output logic[(2*n)-1:0] AQ
); 

logic Creg; // MSB carry bit storage 
  
always_ff @ (posedge clock) 
  if(~nreset) // clear C,A and load Q 
    begin      
      Creg <= 0; 
      AQ[(2*n)-1:n] <= 0; 
      AQ[n-1:0] <= Q; // load multiplier into Q 
    end
  else 
    begin
      if (add) // store Sum in C,A 
        begin 
          Creg <= C; 
          AQ[(2*n)-1:n] <= Sum; 
        end 
      else 
        begin
        if (shift) // shift A,Q 
          begin 
            // use concatenation to implement shift: Carry into MSB of A 
            // and AQ by one bit to right: AQ[0] <= AQ[1], AQ[1] <= AQ[2]; ? 
            // note also that Creg must be cleared 
            {Creg,AQ} <= {1'b0,Creg,AQ[(2*n)-1:1]}; 
          end 
        end
    end
endmodule