//Author: Ashley Robinson
module multiplier // for MachXO implementation ? read MachXO lab notes
#(parameter n=4)
(
  input logic nPB,
  output logic [7:0]leds
);

//MachXO clock needs to be used for switch bouning
OSCC OSCC_INST (.OSC(fastclk));
 
logic add, shift, nreset, ready, C,pulse;//,start;
logic [n-1:0] Sum;
logic [2*n-1:0] AQ;
logic [n-1:0] M, Q;


assign M = 10;
assign Q = 10;

assign clock = pulse;//This cn't be used unless OSCC is
assign start = ~nPB;


//leds are active low - need to invert signals
assign leds = ~AQ;
//assign leds[(2*n)-1] = 0; // remember these are active low so zero when ready

// module instances, note: cannot always use implicit mapping syntax here
Counter c(.fastclk(fastclk),.pulse(pulse));//Turns a fast clock into a slow clock
Adder #(.n(n)) a(.A(AQ[(2*n)-1:n]), .M(M), .C(C), .Sum(Sum)); // must use named mapping here
Regs #(.n(n)) r(.clock(clock), .nreset(nreset), .add(add), .shift(shift), .C(C), .Q(Q), .Sum(Sum), .AQ(AQ));
Sequencer #(.n(n)) s(.clock(clock), .start(start), .Q0(AQ[0]), .add(add), .shift(shift), .nreset(nreset), .ready(ready));
endmodule
