//Author: Ashley Robinson
module Counter 
#(parameter n = 24)  
(
  input logic fastclk, 
  output logic pulse
);

  logic [n-1:0] count;
  // declare an n-bit counter
  // n=26: 2^26 * 1/25MHz = ~2.7 seconds
  // n=24: 2^24 * 1/25MHz = ~0.67 seconds
  // n=18: 2^18 * 1/25MHz = ~10 ms

  always_ff@(posedge fastclk) 
  begin 
    count <= count + 1;
  end

  // copy top bit to output
  assign pulse = count[n-1];

endmodule
