//Author: Ashley Robinson
module Adder
#(parameter n = 4)
(
    input logic[n - 1:0] A,M, 
    output logic C, 
    output logic [n - 1:0] Sum
); 

always_comb
  begin
    Sum = M + A;
    //If the output is lower than either 
    //input carry overflow has occured
    if (Sum < A || Sum < M)
      C = 1'b1;
    else
      C = 1'b0;
  end
endmodule